#pragma once

#include "FTNStruc.hpp"
#include "Areas.h"
#include "BSO.hpp"


/**
 * Max tic line size (not including CRLF).
 * (according to fsc-0087)
 */
const int	MAX_TIC_LINE_SIZE = 254; // FOR DEBUG PURPOSES IT WAS CHANGED FROM 254


// ----------------------------------------------------------------------
// class CTicNamer intended to handle TIC file names. Directly speaking,
// it returns continuously free TIC number for files in desired directory
// ----------------------------------------------------------------------

class CTicNamer {
public:
    CTicNamer();
    CTicNamer(LPCTSTR szSeekPath);
    ~CTicNamer();
    int  getFreeNumber();
    void printDebugInfo();
    void readTICs(LPCTSTR szSeekPath);	// reads tic-files in seekPath directory and
										// calculates their numbers

	/**
	 * Collects tic numbers, but do not find free number yet.
	 */
	void collectTics(int*& numbers, int& numberCount, LPCTSTR path);	

	/**
	 * Collect tic numbers of all tics in any outbound defined (binkley, file boxes)
	 */
	void collectAllOutputTics();

private:
    struct SNumberInterval {
        int number;
        int length;
    };
    SNumberInterval *intervals;
    int              intervalsCount;
    int              freeNumber;
    int              currentInterval;
    void resetFields(); // does reset of fields without freeing memory
    void freeFields();  // frees memory allocated for fields
    int  parseNumber(LPCTSTR szTicName);

	void prepareIntervals(int* numbers, int numberCount);
};



class CTic {
public:
	CTic();
	~CTic();

	bool			Read(LPCTSTR szTicFileName);
	virtual bool	read(const tstring& ticName) { return Read(ticName.c_str()); }
	void			PrintInfo();

	SFTNAddress		m_addrOrigin;
	SFTNAddress		m_addrFrom;
	SFTNAddress		m_addrTo;
	TCHAR			m_szArea[AREA_NAME_SIZE];
	TCHAR			m_szAreaDesc[AREA_DESC_SIZE];
	TCHAR			m_szFile[MAX_PATH];
	TCHAR			m_szFullName[MAX_PATH];
	TCHAR			m_szLongName[MAX_PATH];
	TCHAR			m_szReplaces[MAX_PATH];
	int			m_iSize;
	TCHAR			m_szPW[256];
	TCHAR			m_szDesc[256];
	list<SFTNAddress>	m_listSeenby;
	// CRC32
	bool			m_bCRC32Present;
	UINT			m_uiCRC32;
	vector<tstring>		m_vsDescLines;
	vector<tstring>		m_listLDesc;
	bool			Forward(PLink pLink, PArea area, LPCTSTR szFilePath, vector<PLink>& forwards);
	tstring			GetLastError() const { return (m_sLastError); } // returns last error string

	LPCTSTR getPassword() const { return m_szPW; }

	/**
	 * Gets full name of tic file (with path), stored in Read method
	 */
	LPCTSTR	getFullName() const { return fullName; }
	/**
	 * Gets name of tic file (without path), stored in Read method
	 */
	LPCTSTR	getName() const { return name; }

	LPCTSTR	getFileName() const { return m_szFile; }

	void setSize(int newSize) { m_iSize = newSize; }
	int  getSize() const { return m_iSize; }

	void setCRC32(UINT newCRC32) { m_uiCRC32 = newCRC32; }
	UINT getCRC32() const { return m_uiCRC32; }

	bool isCRC32Present() const { return m_bCRC32Present; }
	void setCRC32Present(bool flag) { m_bCRC32Present = flag; }

	LPCTSTR getAreaName() const { return m_szArea; }
	const SFTNAddress& getSenderAddress() const { return m_addrFrom; }

private:
	TCHAR		m_szMagic[MAX_PATH];
	TCHAR		m_szFromPwd[256];
	TCHAR		m_szCreatedBy[256];
	vector<tstring>	m_listVia;
	vector<tstring>	m_listPath;
	vector<tstring>	m_listUnknown;

	/**
	 * Full name of tic file (with path), stored in Read method
	 */
	TCHAR		fullName[MAX_PATH];
	/**
	 * Name of tic file (without path), pointer to the name in fullName
	 */
	LPTSTR		name;

	CBSOManager	m_BSOManager;

	CTicNamer	m_TicNamer;

	bool		ParseAddr(LPCTSTR s, SFTNAddress &Addr);
	void		Free();

	tstring		m_sLastError;

	struct	SAddr {
		int	m_iZone;
		int	m_iNet;
		int	m_iNode;
		int	m_iPoint;
		tstring	m_sDomain;
	};

	bool		ParseSeenByStrings(vector<tstring>& vsSeenBy, vector<int> viSeenByLine);
	bool		ParseSeenByAddr(LPCTSTR psAddr, int iAddrStrLen, SFTNAddress& addr, SAddr& prevAddr);
};
